#!/usr/bin/perl -w
use Time::HiRes "usleep";

$PORT = "/dev/ttyUSB0";

$start = 0;
$dir = 0x01;

system "stty -F $PORT 115200 raw";

open SER, ">$PORT";
select SER;
$| = 1;
select STDOUT;

while (1) {
	print SER "\x23\x54\x26\x66\x00\x08\x00\x14\x00\x02\x00\x07";
	$start2 = $start;
	$dir2 = $dir;
	for ($y = 0; $y < 8; $y++) {
		$val = $start2;
		$add = $dir2;
		for ($x = 0; $x < 20; $x++) {
			print SER pack("CC", $val & 0x07, $val >> 4);
			$val += $add;
			$add = new_add($val, $add);
		}
		$start2 += $dir2;
		$dir2 = new_add($start2, $dir2);
	}
	$start += $dir;
	$dir = new_add($start, $dir);
	usleep (50000);
}

sub new_add {
	my ($val, $add) = @_;
	if (($val == 7) && ($add == 0x01)) {
		$add = 0x10;
	} elsif (($val == 0x77) && ($add == 0x10)) {
		$add = -0x01;
	} elsif (($val == 0x70) && ($add == -0x01)) {
		$add = -0x10;
	} elsif (($val == 0x00) && ($add == -0x10)) {
		$add = 0x01;
	}
	return $add;
}
