#!/usr/bin/perl -w
use Image::Magick;

# convert png image to single-frame BIN file

if (scalar(@ARGV) < 2) {
	die ("Usage: $0 <duration [ms]> <Filename.png> [<Filename.png> [...]]\n");
}

$duration = shift(@ARGV) / 10;
if (($duration == 0) or ($duration > 65535) or ($duration != int($duration))) {
	die ("Duration must be a multiple of 10 between 10 and 655'350 ms.");
}

foreach $file (@ARGV) {
	if (! -f $file) {
		die ("Image file '$file' not found!\n");
	}
	$image = Image::Magick->new;
	$image->Read($file);
	$width = $image->Get('width');
	$height = $image->Get('height');
	print "Converting '$file' ($width x $height) ...\n";
	@pixels = $image->GetPixels(map=>'I', width=>$width, height=>$height, normalize=>1);
	
	$filename = $file;
	$filename =~ s/\.[A-Za-z0-9]+$//;
	open OUT, ">$filename.bin" or die ("Failed to open BIN file.\n");
	if (($height == 16) or ($height == 40)) {
		$step = 2;
	} else {
		$step = 1;
	}
	
	print OUT pack('v', $duration);
	for ($x = 0; $x < $width; $x++) {
		for ($y = 0; $y < $height; $y+=$step) {
			$p = (1 - $pixels[$y*$width + $x]) * 7;
			print OUT pack('C', $p);
		}
	}
	close OUT;
}
