#!/usr/bin/perl -w

# display incoming MCUF stream (3bpp) with ASCII art

$PORT = "/dev/ttyS1";
$BAUD = 115200;

system "stty -F $PORT $BAUD raw -echo";
open SER, "$PORT";
$x = select SER;
$| = 1;
select $x;

@CHARS = (' ', '-', '~', ':', '?', '%', '&', '#');
while (1) {
	start:
	read(SER, $r, 1); if ($r ne '#') { goto start; } # 0x23
	read(SER, $r, 1); if ($r ne 'T') { goto start; } # 0x54
	read(SER, $r, 1); if ($r ne '&') { goto start; } # 0x26
	read(SER, $r, 1); if ($r ne 'f') { goto start; } # 0x66
	read(SER, $r, 2); $height = unpack("n", $r);
	read(SER, $r, 2); $width = unpack("n", $r);
	read(SER, $r, 2); $channels = unpack("n", $r);
	read(SER, $r, 2); $maxval = unpack("n", $r);
	$bytes = read(SER, $frame, $height*$width);
	if (($channels == 1) && ($maxval < 256)) {
		$n = 0;
		print "\x1b[2J\x1b[H";
		print $bytes, "\n";
		for ($y = 0; $y < $height; $y++) {
			for ($x = 0; $x < $width; $x++) {
				$data = unpack("C", substr($frame, $n, 1));
				if ($data > 7) {
					print "#";
				} else {
					print $CHARS[$data];
				}
				$n++;
			}
			print "\n";
		}
	}
}
