#!/usr/bin/perl -w
use Image::Magick;

# convert png image to single-frame flash animation (without duration)
# supports color (R/G and R/G/B) with black background!

if (scalar(@ARGV) < 1) {
	die ("Usage: $0 <Filename.png> [<Filename.png> [...]]\n");
}

foreach $file (@ARGV) {
	if (! -f $file) {
		die ("Image file '$file' not found!\n");
	}
	$filename = $file;
	$filename =~ s/\.[A-Za-z0-9]+$//;
	
	$image = Image::Magick->new;
	$image->Read($file);
	$width = $image->Get('width');
	$height = $image->Get('height');
	if ($filename =~ /-2$/) {
		@pixels = $image->GetPixels(map=>'RG', width=>$width, height=>$height, normalize=>1);
		$width *= 2;
		$colors = 2;
	} elsif ($filename =~ /-3$/) {
		@pixels = $image->GetPixels(map=>'RGB', width=>$width, height=>$height, normalize=>1);
		$width *= 3;
		$colors = 3;
	} else {
		@pixels = $image->GetPixels(map=>'I', width=>$width, height=>$height, normalize=>1);
		$colors = 1;
	}
	print "Converting '$file' ($width x $height x $colors) ...\n";
	
	open OUT, ">$filename.asm" or die ("Failed to open ASM file.\n");
	if (($width/$colors == 26) && ($height == 40)) {
		$step = 2;
		print "Detected aspect-corrected ARCADE image, dividing height by 2.\n";
	} else {
		$step = 1;
	}
	
	$n = 0;
	for ($y = 0; $y < $height; $y+=$step) {
		for ($x = 0; $x < $width; $x+=2) {
			if ($n % 10 == 0) {
				print OUT "\n.db ";
			} else {
				print OUT ", ";
			}
			$p1 = int($pixels[$y*$width + $x] * 7.9999);
			$p2 = int($pixels[$y*$width + $x + 1] * 7.9999);
			$p = $p1 | ($p2 << 4);
			printf OUT "0x%02X", $p;
			$n++;
		}
	}
	print OUT "\n";
	close OUT;
}
