;Configuration Settings for BlinkenPlus



;Supported Projects
.equ	NO_PROJECT = 0 ;use user-defined settings below
;  *** BlinkenLights (18x8) monochrome ***
.equ	PROJECT_BSA = 1          ;BlinkstroemAdvanced (by Kai Gossner, 2004)
.equ	PROJECT_BSAS = 2         ;BlinkstroemAdvanced-Stream (Kai & Arne, 2008)
.equ	PROJECT_BSAPLUS = 3      ;BlinkstroemAdvanced Plus
.equ	PROJECT_BLPLUS0 = 4      ;BlinkenLEDs Plus Prototype
.equ	PROJECT_BLPLUS1 = 5      ;BlinkenLEDs Plus Rev. 1
.equ	PROJECT_BLPLUS3 = 6      ;BlinkenLEDs Plus Rev. 3
.equ	PROJECT_TICTACLIGHTS = 7 ;TicTacLights
.equ	PROJECT_TTL = PROJECT_TICTACLIGHTS
; *** BlinkenLights (18x8) RGB ***
.equ	PROJECT_BSC = 50 ;Blinkstroem Colour
.equ	PROJECT_TLC = 51 ;TicTacLights Colour
.equ	PROJECT_BPC = 52 ;BlinkenLEDs Plus Colour
;  *** ARCADE ***
.equ	PROJECT_ARCADEMICRO = 100 ;ArcadeMicro
.equ	PROJECT_AMC1 = 101        ;ArcadeMicro Colour Rev. 1.0
;  *** other formats ***
.equ	PROJECT_POLLINMATRIX = 200 ;red/green 20x8 pixel matrix display (M16)
.equ	PROJECT_POLLINMATRIX_MEGA32 = 201 ;same with Mega32 controller

;Output Modules
.equ	OUTPUT_BL = 1         ;BlinkenLights (18x8, monochrome), row-muxed
.equ	OUTPUT_BL_COLMUX = 2  ;BlinkenLights (18x8, monochrome), col-muxed
.equ	OUTPUT_ARCADE = 3     ;ARCADE (26x20, monochrome), row-muxed
.equ	OUTPUT_20X8_RG = 4    ;20x8xRG (red/green) = 40x8, row-muxed
.equ	OUTPUT_BL_RGB = 5     ;BlinkenLights RGB (18x8xRGB = 18x24), col-muxed
.equ	OUTPUT_ARCADE_RGB = 6 ;ARCADE RGB (26x20xRGB = 78x20), row-muxed
.equ	OUTPUT_SPLITTER = 99  ;Stream splitter

;Supported Microcontrollers
.equ	MCU_MEGA16 = 1
.equ	MCU_MEGA32 = 2
.equ	MCU_MEGA8515 = 3
.equ	MCU_MEGA162 = 4
.equ	MCU_MEGA644 = 5
.equ	MCU_MEGA644P = 6

;**********************
;**  Select Project  **
;**********************
.equ	PROJECT = PROJECT_TTL
;.equ	PROJECT = NO_PROJECT

;===============================================================================

;*******************************************
;**  General Settings (for all projects)  **
;*******************************************

;Duration (in seconds) after which to return to flash animation if no valid data
;was received for the entire duration (set to 0 to disable timeout)
.equ	STREAM_TIMEOUT_VAL = 30

;Receive and display MCUF stream (when no SD Card is inserted)
.equ	STREAM_INPUT = 1

;Output an MCUF stream of the display contents (regardless of the source of the
;display contents)
.equ	STREAM_OUTPUT = 1

;Enable SD card functionality (disable to save program memory)
.equ	USE_SDCARD = 1

;Output debug messages to RS232 (no stream output possible)
.equ	DEBUG = 0

;Additional debugging output (only active if DEBUG = 1 above). Enabling these
;options may affect playback speed and display quality!
.equ	DEBUG_FAT = 1 ;heavy FAT debugging
.equ	DEBUG_PLAYBACK = 1 ;heavy animation playback debugging
.equ	DEBUG_SDCARD = 0 ;display <address> & {dumped}
.equ	DEBUG_STREAM = 0 ;display ? for every call to getc
.equ	DEBUG_PARSE = 0 ;heavy debugging of file parsing (BLM and BML)

;Disable scrolling messages (for faster debugging)
.equ	MESSAGE_DISABLE = 0

;===============================================================================

.if (PROJECT == NO_PROJECT)
	
	;***************************************************
	;**  User-defined Settings (no project selected)  **
	;***************************************************
	
	;Microcontroller
	.equ	MCU = MCU_MEGA644
	
	;LED matrix width, height and number of channels (colours)
	;  WIDTH must be an even number!
	;  stream splitter: size of the input frames (not the output frames),
	;                   WIDTH must be a multiple of SPLIT_V,
	;                   HEIGHT must be a multiple of SPLIT_H
	;  monochrome = 1 channel, red/green = 2 channels, RGB = 3 channels
	.equ	WIDTH = 40
	.equ	HEIGHT = 16
	.equ	CHANNELS = 2
	
	;select output driver
	.equ	OUTPUT = OUTPUT_SPLITTER
	
	;how to split the frames (only with OUTPUT_SPLITTER)
	;  output streams will have frame size:
	;  (WIDTH / SPLIT_V) x (HEIGHT / SPLIT_H)
	;  possible combinations: (1x1), 1x2, 2x1, 2x2, 1x3, 3x1, 1x4, 4x1
	.equ	SPLIT_V = 2
	.equ	SPLIT_H = 2
	
	;Row Output Polarity: active-low row outputs when set to 1
	;(ignored with OUTPUT_SPLITTER)
	.equ	OUT_INVERT_ROWS = 1
	
	;Column Output Polarity: active-low column outputs when set to 1
	;(ignored with OUTPUT_SPLITTER)
	.equ	OUT_INVERT_COLUMNS = 0
	
	;reverse PORT A bit order (only with OUTPUT_BL)
	.equ	OUT_REVERSE_PORTA = 0
	
	;correction for BlinkenLEDs Plus Kit Rev.1 (Mega16) PCB layout mistake
	;(only with OUTPUT_BL)
	.equ	OUT_BLPLUS_REV1_CORRECTION = 0
	
	;correction for ArcadeMicro Colour Kit Rev.1 PCB layout mistake
	;(only with OUTPUT_ARCADE)
	.equ	OUT_AMC_REV1_CORRECTION = 1
	
	;move row 7 output from PD0 to PB3 (for BSA-Stream,
	;only with OUTPUT_BL_COLMUX)
	.equ	OUT_MOVE_ROW1 = 0
	
	;enable baud rate jumpers (only set to 1 with OUTPUT_BL)
	.equ	JUMPERS = 0
	
	;select baudrate(s) for different jumper settings (for 14.7456 MHz)
	.equ	BAUDRATE1 = 115200 ;both jumpers open (or project w/o jumpers)
	.equ	BAUDRATE2 = 57600  ;jumper 1 closed
	.equ	BAUDRATE3 = 38400  ;jumper 2 closed
	.equ	BAUDRATE4 = 19200  ;both jumpers closed
	
	;play BS2.BIN file in root dir if animation directory not present
	.equ	BS2BIN = 0
	
	;directory name in which to look for animations (exactly 11 characters,
	;last three are the filename extension, all uppercase, padded with
	;spaces, zero-terminated, examples:
	;  ANIMS      = "ANIMS      ",0  (standard directory name)
	;  ANIM.DIR   = "ANIM    DIR",0  (directory name with extension)
	;  Animations = "ANIMAT~1   ",0  (long name, no similar names exist)
	.macro _DIRNAME
	.db "PM40X16    ",0
	.endmacro
	
	.message "Selected Project: none (manual configuration)"
	
.elif (PROJECT == PROJECT_BSA)

	;Project settings for BlinkstroemAdvanced
	.equ	MCU = MCU_MEGA16
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_BL_COLMUX
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	OUT_MOVE_ROW1 = 0
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 53084 ;57600 Baud @ 16 MHz
	.equ	BS2BIN = 1
	
	.macro	_DIRNAME
	.db "BLPLUS     ",0
	.endmacro
	
	.message "Selected Project: BlinkstroemAdvanced (original)"
	
.elif (PROJECT == PROJECT_BSAS)

	;Project settings for BlinkstroemAdvanced-Stream
	.equ	MCU = MCU_MEGA16
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_BL_COLMUX
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	OUT_MOVE_ROW1 = 1
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 53084 ;57600 Baud @ 16 MHz
	.equ	BS2BIN = 1
	
	.macro	_DIRNAME
	.db "BLPLUS     ",0
	.endmacro
	
	.message "Selected Project: BlinkstroemAdvanced-Stream"
	
.elif (PROJECT == PROJECT_BLPLUS0)

	;Project settings for BlinkenLEDs Plus Prototype
	.equ	MCU = MCU_MEGA16
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_BL
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 0
	.equ	OUT_REVERSE_PORTA = 1
	.equ	OUT_BLPLUS_REV1_CORRECTION = 0
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 57600
	.equ	BS2BIN = 1
	
	.macro	_DIRNAME
	.db "BLPLUS     ",0
	.endmacro
	
	.message "Selected Project: BlinkenLEDs Plus Prototype"
	
.elif (PROJECT == PROJECT_BLPLUS1)

	;Project settings for BlinkenLEDs Plus Rev. 1
	.equ	MCU = MCU_MEGA16
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_BL
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	OUT_REVERSE_PORTA = 1
	.equ	OUT_BLPLUS_REV1_CORRECTION = 1
	.equ	JUMPERS = 1
	.equ	BAUDRATE1 = 57600
	.equ	BAUDRATE2 = 115200
	.equ	BAUDRATE3 = 230400
	.equ	BAUDRATE4 = 460800
	.equ	BS2BIN = 1
	
	.macro	_DIRNAME
	.db "BLPLUS     ",0
	.endmacro
	
	.message "Selected Project: BlinkenLEDs Plus Rev. 1"
	
.elif (PROJECT == PROJECT_BLPLUS3)

	;Project settings for BlinkenLEDs Plus Rev. 3
	.equ	MCU = MCU_MEGA8515
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_BL
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	OUT_REVERSE_PORTA = 1
	.equ	OUT_BLPLUS_REV1_CORRECTION = 0
	.equ	JUMPERS = 1
	.equ	BAUDRATE1 = 115200
	.equ	BAUDRATE2 = 57600
	.equ	BAUDRATE3 = 38400
	.equ	BAUDRATE4 = 19200
	.equ	BS2BIN = 1
	
	.macro	_DIRNAME
	.db "BLPLUS     ",0
	.endmacro
	
	.message "Selected Project: BlinkenLEDs Plus Rev. 3"
	
.elif (PROJECT == PROJECT_BSAPLUS)

	;Project settings for BlinkstroemAdvanced Plus
	.equ	MCU = MCU_MEGA8515
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_BL
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	OUT_REVERSE_PORTA = 0
	.equ	OUT_BLPLUS_REV1_CORRECTION = 0
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 115200
	.equ	BS2BIN = 1
	
	.macro	_DIRNAME
	.db "BLPLUS     ",0
	.endmacro
	
	.message "Selected Project: BlinkstroemAdvanced Plus"
	
.elif (PROJECT == PROJECT_TICTACLIGHTS)

	;Project settings for TicTacLights
	.equ	MCU = MCU_MEGA8515
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_BL
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 0
	.equ	OUT_REVERSE_PORTA = 0
	.equ	OUT_BLPLUS_REV1_CORRECTION = 0
	.equ	JUMPERS = 1
	.equ	BAUDRATE1 = 115200
	.equ	BAUDRATE2 = 57600
	.equ	BAUDRATE3 = 38400
	.equ	BAUDRATE4 = 19200
	.equ	BS2BIN = 1
	
	.macro	_DIRNAME
	.db "BLPLUS     ",0
	.endmacro
	
	.message "Selected Project: TicTacLights"
	
.elif (PROJECT == PROJECT_BPC)

	;Project settings for BlinkenLEDs Plus Colour
	.equ	MCU = MCU_MEGA162
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 3
	.equ	OUTPUT = OUTPUT_BL_RGB
	.equ	OUT_INVERT_ROWS = 1
	.equ	OUT_INVERT_COLUMNS = 0
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 115200
	.equ	BS2BIN = 0
	
	.macro	_DIRNAME
	.db "BP18X8  RGB",0 ;use directory "BP18X8.RGB"
	.endmacro
	
	.message "Selected Project: BlinkenLEDs Plus Colour"
	
.elif (PROJECT == PROJECT_BSC)

	;Project settings for Blinkstroem Colour
	.equ	MCU = MCU_MEGA162
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 3
	.equ	OUTPUT = OUTPUT_BL_RGB
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 115200
	.equ	BS2BIN = 0
	
	.macro	_DIRNAME
	.db "BP18X8  RGB",0 ;use directory "BP18X8.RGB"
	.endmacro
	
	.message "Selected Project: Blinkstroem Colour"
	
.elif (PROJECT == PROJECT_TLC)

	;Project settings for TicTacLights Colour
	.equ	MCU = MCU_MEGA162
	.equ	WIDTH = 18
	.equ	HEIGHT = 8
	.equ	CHANNELS = 3
	.equ	OUTPUT = OUTPUT_BL_RGB
	.equ	OUT_INVERT_ROWS = 1
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 115200
	.equ	BS2BIN = 0
	
	.macro	_DIRNAME
	.db "BP18X8  RGB",0 ;use directory "BP18X8.RGB"
	.endmacro
	
	.message "Selected Project: TicTacLights Colour"
	
.elif (PROJECT == PROJECT_ARCADEMICRO)

	;Project settings for ArcadeMicro
	.equ	MCU = MCU_MEGA162
	.equ	WIDTH = 26
	.equ	HEIGHT = 20
	.equ	CHANNELS = 1
	.equ	OUTPUT = OUTPUT_ARCADE
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 1
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 115200
	.equ	BS2BIN = 0
	
	.macro	_DIRNAME
	.db "ARCADE     ",0
	.endmacro
	
	.message "Selected Project: ArcadeMicro"
	
.elif (PROJECT == PROJECT_AMC1)

	;Project settings for ArcadeMicro Colour (Rev. 1.0 with layout mistake)
	.equ	MCU = MCU_MEGA644P
	.equ	WIDTH = 26
	.equ	HEIGHT = 20
	.equ	CHANNELS = 3
	.equ	OUTPUT = OUTPUT_ARCADE_RGB
	.equ	OUT_INVERT_ROWS = 1
	.equ	OUT_INVERT_COLUMNS = 0
	.equ	OUT_AMC_REV1_CORRECTION = 1
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 115200
	.equ	BS2BIN = 0
	
	.macro	_DIRNAME
	.db "ARCADE  RGB",0
	.endmacro
	
	.message "Selected Project: ArcadeMicro Colour"
	
.elif ((PROJECT == PROJECT_POLLINMATRIX) || (PROJECT == PROJECT_POLLINMATRIX_MEGA32))

	;Project settings for PollinMatrix (red/green 20x8 pixel matrix)
  .if (PROJECT == PROJECT_POLLINMATRIX_MEGA32)
	.message "Selected Project: PollinMatrix with ATmega16"
	.equ	MCU = MCU_MEGA16
  .else
	.message "Selected Project: PollinMatrix with ATmega32"
	.equ	MCU = MCU_MEGA32
  .endif
	.equ	WIDTH = 20
	.equ	HEIGHT = 8
	.equ	CHANNELS = 2
	.equ	OUTPUT = OUTPUT_20X8_RG
	.equ	OUT_INVERT_ROWS = 0
	.equ	OUT_INVERT_COLUMNS = 0
	.equ	JUMPERS = 0
	.equ	BAUDRATE1 = 115200
	.equ	BS2BIN = 0
	
	.macro	_DIRNAME
	.db "BP20X8-2   ",0
	.endmacro
	
.else
	
	;unknown project selected
	.error "Unknown project selected in 'config.inc'!"
	
.endif
