#!/usr/bin/perl -w

# display incoming MCUF stream (3bpp) with ASCII art

$PORT = "/dev/ttyUSB0";
$BAUD = 115200;

system "stty -F $PORT $BAUD raw -echo";
open SER, "$PORT";
$x = select SER;
$| = 1;
select $x;

use Term::ANSIColor;
@CHARS = (' ', '-', '~', ':', '?', '%', '&', '#');
while (1) {
	start:
	read(SER, $r, 1); if ($r ne '#') { goto start; } # 0x23
	read(SER, $r, 1); if ($r ne 'T') { goto start; } # 0x54
	read(SER, $r, 1); if ($r ne '&') { goto start; } # 0x26
	read(SER, $r, 1); if ($r ne 'f') { goto start; } # 0x66
	read(SER, $r, 2); $height = unpack("n", $r);
	read(SER, $r, 2); $width = unpack("n", $r);
	read(SER, $r, 2); $channels = unpack("n", $r);
	read(SER, $r, 2); $maxval = unpack("n", $r);
	$bytes = read(SER, $frame, $height*$width*$channels);
	$n = 0;
	print "\x1b[2J\x1b[H";
	print "Format: ", $width*$height, "-", $channels, " (", $bytes, " bytes)\n";
	if (($channels == 1) && ($maxval < 256)) {
		for ($y = 0; $y < $height; $y++) {
			for ($x = 0; $x < $width; $x++) {
				$data = unpack("C", substr($frame, $n, 1));
				if ($data > 7) {
					print "#";
				} else {
					print $CHARS[$data];
				}
				$n++;
			}
			print "\n";
		}
	} elsif (($channels == 2) && ($maxval < 256)) {
		for ($y = 0; $y < $height; $y++) {
			for ($x = 0; $x < $width; $x++) {
				($red, $green) = unpack("CC", substr($frame, $n, 2));
				if ($red > 0) {
					$color = "bold red";
				}
				if ($green > 0) {
					$color = "bold green";
				}
				if (($green >= $red) && ($red > 0)) {
					if ($green - $red < 4) {
						$color = "bold yellow";
					} else {
						$color = "bold green";
					}
				} elsif (($red >= $green) && ($green > 0)) {
					if ($red - $green < 4) {
						$color = "bold yellow";
					} else {
						$color = "bold red";
					}
				}
				$data = ($red > $green) ? $red : $green;
				if ($data > 7) {
					print colored("#", $color);
				} else {
					print colored($CHARS[$data], $color);
				}
				$n += 2;
			}
			print "\n";
		}
	}
}
