#!/usr/bin/perl -w
use Device::SerialPort;

# turn on pixels on for monochrome projects

if (scalar(@ARGV) < 3) {
	die "Usage: $0 <PORT>[:<BAUD>] <WIDTH> <HEIGHT> [<CHANNELS> [<COLOR>]]\n" .
	"\n" .
	"  <PORT>      Serial port device (e.g. /dev/ttyS0 or /dev/ttyUSB0)\n" .
	"  <BAUD>      Baudrate (optional, default 115200)\n" .
	"  <WIDTH>     Display width in pixels (e.g. 18)\n" .
	"  <HEIGHT>    Display height in pixels (e.g. 8)\n" .
	"  <CHANNELS>  Display color depth (optional, default 1):\n" .
	"              1 = grayscale, 2 = RG, 3 = RGB\n" .
	"  <COLOR>     Display color (optional, default RG: yellow, RGB: white)\n" .
	"              1ch: black, white, numeric: 0~7\n" .
	"              2ch: black, white, red, yellow, green, numeric: 00~77\n" .
	"              3ch: black, white, red, yellow, green, cyan, blue,\n" . 
	"                   violet/magenta, numeric: 000~777\n\n";
}

$PORT = $ARGV[0];
if ($PORT =~ /^([^:]+):([0-9]+)$/) {
	$PORT = $1;
	$BAUD = $2;
} else {
	$BAUD = 115200;
}
$WIDTH = $ARGV[1];
$HEIGHT = $ARGV[2];
if (scalar(@ARGV) >= 4) {
	$CHANNELS = $ARGV[3];
} else {
	$CHANNELS = 1;
}
if (scalar(@ARGV) >= 5) {
	$COLOR = $ARGV[4];
} else {
	$COLOR = 'w';
}

$PIXEL = $COLOR;
for ($COLOR) {
	$PIXEL = '777' if (/^w/i or /^white/i);
	$PIXEL = '000' if (/^k/i or /^black/i);
	$PIXEL = '700' if (/^r/i or /^red/i);
	$PIXEL = '770' if (/^y/i or /^yellow/i);
	$PIXEL = '070' if (/^g/i or /^green/i);
	$PIXEL = '077' if (/^c/i or /^cyan/i);
	$PIXEL = '007' if ((not /^black/) and (/^b/i or /^blue/i));
	$PIXEL = '707' if (/^v/i or /^violet/i or /^m/i or /^magenta/i);
}
$DATA = '';
for ($i = 0; $i < $CHANNELS; $i++) {
	$DATA .= pack('C', substr($PIXEL, $i, 1));
}

$ser = Device::SerialPort->new("$PORT");
$ser->baudrate($BAUD);
$ser->databits(8);
$ser->parity("none");
$ser->stopbits(1);
$ser->handshake("none");
$ser->write_settings;

print "Sending stream: ${WIDTH}x${HEIGHT}-${CHANNELS}/8 for color = ",
      substr($PIXEL, 0, $CHANNELS), "\n";

$ser->write("\x23\x54\x26\x66" . pack('nnn', $HEIGHT, $WIDTH, $CHANNELS) .
            "\x00\x07");
# for some reason, writing the entire frame in one write command doesn't work
for ($y = 0; $y < $HEIGHT; $y++) {
	$ser->write($DATA x $WIDTH);
}

$ser->write_drain;
$ser->close();

