#!/usr/bin/perl -w

# display incoming MCUF stream (3bpp) with ASCII art

die "Usage: $0 <PORT> [<BAUD>]\n" if (scalar(@ARGV) == 0);

$PORT = $ARGV[0];
if (scalar(@ARGV) >= 2) {
	$BAUD = $ARGV[1];
} else {
	$BAUD = 115200;
}

system "stty -F $PORT $BAUD raw -echo";
open SER, "$PORT";
$x = select SER;
$| = 1;
select $x;

use Term::ANSIColor;
@CHARS = (' ', '-', '~', ':', '?', '%', '&', '#');
$frames = 0;
print "Waiting ...";
while (1) {
	start:
	print ".";
	read(SER, $r, 1); if ($r ne '#') { goto start; } # 0x23
	read(SER, $r, 1); if ($r ne 'T') { goto start; } # 0x54
	read(SER, $r, 1); if ($r ne '&') { goto start; } # 0x26
	read(SER, $r, 1); if ($r ne 'f') { goto start; } # 0x66
	read(SER, $r, 2); $height = unpack("n", $r);
	read(SER, $r, 2); $width = unpack("n", $r);
	read(SER, $r, 2); $channels = unpack("n", $r);
	read(SER, $r, 2); $maxval = unpack("n", $r);
	$bytes = read(SER, $frame, $height*$width*$channels);
	$n = 0;
	$frames++;
	print "\x1b[2J\x1b[H";
	print "Format: ${width}x${height}-$channels/", $maxval+1, " ($bytes bytes), Frames: $frames\n";
	@ERRORS = ();
	if (($channels == 1) && ($maxval < 256)) {
		for ($y = 0; $y < $height; $y++) {
			for ($x = 0; $x < $width; $x++) {
				$data = unpack("C", substr($frame, $n, 1));
				if ($data > 7) {
					push @ERRORS, "Pixeldata too high: ($x, $y) = $data";
					print "E"; # error: value too high
				} else {
					print $CHARS[$data];
				}
				$n++;
			}
			print "\n";
		}
	} elsif (($channels == 2) && ($maxval < 256)) {
		for ($y = 0; $y < $height; $y++) {
			for ($x = 0; $x < $width; $x++) {
				$color = "white";
				($red, $green) = unpack("CC", substr($frame, $n, 2));
				if ($red > 0) {
					$color = "bold red";
				}
				if ($green > 0) {
					$color = "bold green";
				}
				if (($green >= $red) && ($red > 0)) {
					if ($green - $red < $green/2) {
						$color = "bold yellow";
					} else {
						$color = "bold green";
					}
				} elsif (($red >= $green) && ($green > 0)) {
					if ($red - $green < $red/2) {
						$color = "bold yellow";
					} else {
						$color = "bold red";
					}
				}
				$data = ($red > $green) ? $red : $green;
				if ($data > 7) {
					print colored("E", $color); # error: value too high
					push @ERRORS, "Pixeldata too high: ($x, $y) = $data";
				} else {
					print colored($CHARS[$data], $color);
				}
				$n += 2;
			}
			print "\n";
		}
	} elsif (($channels == 3) && ($maxval < 256)) {
		# RGB display
		for ($y = 0; $y < $height; $y++) {
			for ($x = 0; $x < $width; $x++) {
				$color = "white";
				($red, $green, $blue) = unpack("CCC", substr($frame, $n, 3));
				# TODO: unnecessary?
				if ($red > 0) {
					$color = "bold red";
				}
				if ($green > 0) {
					$color = "bold green";
				}
				if ($blue > 0) {
					$color = "bold blue";
				}
				# TODO end of unnecessary block
				if (($red >= $green) && ($red >= $blue)) {
					if (($red - $green <= $red/2) && ($red - $blue <= $red/2)) {
						$color = "bold white";
					} elsif (($red - $green <= $red/2) && ($red - $blue > $red/2)) {
						$color = "bold yellow";
					} elsif (($red - $green > $red/2) && ($red - $blue <= $red/2)) {
						$color = "bold magenta";
					} else {
						$color = "bold red";
					}
				} elsif (($green >= $red) && ($green >= $blue)) {
					if (($green - $red <= $green/2) && ($green - $blue <= $green/2)) {
						$color = "bold white";
					} elsif (($green - $red <= $green/2) && ($green - $blue > $green/2)) {
						$color = "bold yellow";
					} elsif (($green - $red > $green/2) && ($green - $blue <= $green/2)) {
						$color = "bold cyan";
					} else {
						$color = "bold green";
					}
				} else {
					if (($blue - $red <= $blue/2) && ($blue - $green <= $blue/2)) {
						$color = "bold white";
					} elsif (($blue - $red <= $blue/2) && ($blue - $green > $blue/2)) {
						$color = "bold magenta";
					} elsif (($blue - $red > $blue/2) && ($blue - $green <= $blue/2)) {
						$color = "bold cyan";
					} else {
						$color = "bold blue";
					}
				}
				if (($red >= $green) && ($red >= $blue)) {
					$data = $red;
				} elsif (($green >= $red) && ($green >= $blue)) {
					$data = $green;
				} else {
					$data = $blue;
				}
				if ($data > 7) {
					print colored("E", $color); # error: value too high
					push @ERRORS, "Pixeldata too high: ($x, $y) = $data";
				} else {
					print colored($CHARS[$data], $color);
				}
				$n += 3;
			}
			print "\n";
		}
	}
	if (scalar(@ERRORS) > 0) {
		print join("\n", @ERRORS), "\n";
		die;
	}
}
