#!/usr/bin/perl -w
use Image::Magick;

# convert png image to single-frame flash animation (without duration)

if (scalar(@ARGV) < 2) {
	die ("Usage: $0 <Filename.png> [<Filename.png> [...]]\n");
}

foreach $file (@ARGV) {
	if (! -f $file) {
		die ("Image file '$file' not found!\n");
	}
	$image = Image::Magick->new;
	$image->Read($file);
	$width = $image->Get('width');
	$height = $image->Get('height');
	print "Converting '$file' ($width x $height) ...\n";
	@pixels = $image->GetPixels(map=>'I', width=>$width, height=>$height, normalize=>1);
	
	$filename = $file;
	$filename =~ s/\.[A-Za-z0-9]+$//;
	open OUT, ">$filename.asm" or die ("Failed to open ASM file.\n");
	if (($height == 16) or ($height == 40)) {
		$step = 2;
	} else {
		$step = 1;
	}
	
	$n = 0;
	for ($y = 0; $y < $height; $y+=$step) {
		for ($x = 0; $x < $width; $x+=2) {
			if ($n % 10 == 0) {
				print OUT "\n.db ";
			} else {
				print OUT ", ";
			}
			$p1 = int((1 - $pixels[$y*$width + $x]) * 7.9999);
			$p2 = int((1 - $pixels[$y*$width + $x + 1]) * 7.9999);
			$p = $p1 | ($p2 << 4);
			printf OUT "0x%02X", $p;
			$n++;
		}
	}
	print OUT "\n";
	close OUT;
}
