#!/usr/bin/perl -w
use Time::HiRes "usleep";

# send a test stream with a moving diagonal grayscale pattern

die "Usage: $0 <WIDTH> <HEIGHT> <PORT> [<BAUD>]\n" if (scalar(@ARGV) < 3);

$WIDTH = $ARGV[0];
$HEIGHT = $ARGV[1];
$PORT = $ARGV[2];
if (scalar(@ARGV) >= 4) {
	$BAUD = $ARGV[3];
} else {
	$BAUD = 115200;
}
$CHANNELS = 1;

system "stty -F $PORT $BAUD raw -echo";
open SER, ">$PORT";
$x = select SER;
$| = 1;
select $x;

print "Sending stream: ${WIDTH}x${HEIGHT}-1/8\n";

$start = 0;
$dir = 1;

while (1) {
	print SER "\x23\x54\x26\x66", pack('nnn', $HEIGHT, $WIDTH, $CHANNELS), "\x00\x07";
	$start2 = $start;
	$dir2 = $dir;
	for ($y = 0; $y < $HEIGHT; $y++) {
		$val = $start2;
		$add = $dir2;
		for ($x = 0; $x < $WIDTH; $x++) {
			print SER pack("C", $val);
			$val += $add;
			if ($val >= 7) {
				$add = -1;
			} elsif ($val <= 0) {
				$add = 1;
			}
		}
		$start2 += $dir2;
		if ($start2 >= 7) {
			$dir2 = -1;
		} elsif ($start2 <= 0) {
			$dir2 = 1;
		}
	}
	$start += $dir;
	if ($start >= 7) {
		$dir = -1;
	} elsif ($start <= 0) {
		$dir = 1;
	}
	usleep (50000);
}
