#!/usr/bin/perl -w
use Time::HiRes "usleep";

$PORT = "/dev/ttyUSB0";

$start = 0;
$dir = 0x001;

system "stty -F $PORT 115200 raw";

open SER, ">$PORT";
select SER;
$| = 1;
select STDOUT;

while (1) {
	print SER "\x23\x54\x26\x66\x00\x08\x00\x12\x00\x03\x00\x07";
	$start2 = $start;
	$dir2 = $dir;
	for ($y = 0; $y < 8; $y++) {
		$val = $start2;
		$add = $dir2;
		for ($x = 0; $x < 18; $x++) {
			print SER pack("CCC", $val & 0x07, ($val >> 4) & 0x07, ($val >> 8));
			$val += $add;
			$add = new_add($val, $add);
		}
		$start2 += $dir2;
		$dir2 = new_add($start2, $dir2);
	}
	$start += $dir;
	$dir = new_add($start, $dir);
	usleep (50000);
}

sub new_add {
	my ($val, $add) = @_;
	if (($val == 0x007) && (($add == 0x001) || ($add == -0x100))) {
		$add = 0x010;
	} elsif (($val == 0x077) && ($add == 0x010)) {
		$add = -0x001;
	} elsif (($val == 0x070) && ($add == -0x001)) {
		$add = 0x100;
	} elsif (($val == 0x770) && ($add == 0x100)) {
		$add = -0x010;
	} elsif (($val == 0x700) && ($add == -0x010)) {
		$add = 0x001;
	} elsif (($val == 0x707) && ($add == 0x001)) {
		$add = -0x100;
	}
	return $add;
}
